/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.logging.LogUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChatPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.game.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.SpigotTimings;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftSign;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_18_R2.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.Vector;
import org.magmafoundation.magma.helpers.InventoryViewHelper;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerGamePacketListenerImpl
implements ServerPlayerConnection,
ServerGamePacketListener {
    static final Logger f_9744_ = LogUtils.getLogger();
    private static final int f_143608_ = 15000;
    public final Connection f_9742_;
    private final MinecraftServer f_9745_;
    public ServerPlayer f_9743_;
    private int f_9746_;
    private long f_9747_;
    private boolean f_9748_;
    private long f_9749_;
    public int f_9750_;
    private int f_9751_;
    private double f_9753_;
    private double f_9754_;
    private double f_9755_;
    private double f_9756_;
    private double f_9757_;
    private double f_9758_;
    @Nullable
    private net.minecraft.world.entity.Entity f_9759_;
    private double f_9760_;
    private double f_9761_;
    private double f_9762_;
    private double f_9763_;
    private double f_9764_;
    private double f_9765_;
    @Nullable
    private Vec3 f_9766_;
    private int f_9767_;
    private int f_9735_;
    private boolean f_9736_;
    private int f_9737_;
    private boolean f_9738_;
    private int f_9739_;
    private int f_9740_;
    private int f_9741_;
    private final CraftServer cserver;
    public boolean processedDisconnect;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    PlayerTeleportEvent.TeleportCause teleportCause = PlayerTeleportEvent.TeleportCause.UNKNOWN;
    private boolean teleportResult = true;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private static final ResourceLocation CUSTOM_REGISTER = new ResourceLocation("register");
    private static final ResourceLocation CUSTOM_UNREGISTER = new ResourceLocation("unregister");

    public ServerGamePacketListenerImpl(MinecraftServer p_9770_, Connection p_9771_, ServerPlayer p_9772_) {
        this.f_9745_ = p_9770_;
        this.f_9742_ = p_9771_;
        p_9771_.m_129505_((PacketListener)this);
        this.f_9743_ = p_9772_;
        p_9772_.f_8906_ = this;
        this.f_9747_ = Util.m_137550_();
        p_9772_.m_8967_().m_7674_();
        this.cserver = p_9770_.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.f_9743_ == null ? null : this.f_9743_.getBukkitEntity();
    }

    public void m_9933_() {
        SpigotTimings.playerConnectionTimer.startTiming();
        this.m_9953_();
        this.f_9743_.f_19854_ = this.f_9743_.m_20185_();
        this.f_9743_.f_19855_ = this.f_9743_.m_20186_();
        this.f_9743_.f_19856_ = this.f_9743_.m_20189_();
        this.f_9743_.m_9240_();
        this.f_9743_.m_19890_(this.f_9753_, this.f_9754_, this.f_9755_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
        ++this.f_9746_;
        this.f_9741_ = this.f_9740_;
        if (this.f_9736_ && !this.f_9743_.m_5803_() && !this.f_9743_.m_20159_()) {
            if (++this.f_9737_ > 80) {
                f_9744_.warn("{} was kicked for floating too long!", (Object)this.f_9743_.m_7755_().getString());
                this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.flying")));
                return;
            }
        } else {
            this.f_9736_ = false;
            this.f_9737_ = 0;
        }
        this.f_9759_ = this.f_9743_.m_20201_();
        if (this.f_9759_ != this.f_9743_ && this.f_9759_.m_6688_() == this.f_9743_) {
            this.f_9760_ = this.f_9759_.m_20185_();
            this.f_9761_ = this.f_9759_.m_20186_();
            this.f_9762_ = this.f_9759_.m_20189_();
            this.f_9763_ = this.f_9759_.m_20185_();
            this.f_9764_ = this.f_9759_.m_20186_();
            this.f_9765_ = this.f_9759_.m_20189_();
            if (this.f_9738_ && this.f_9743_.m_20201_().m_6688_() == this.f_9743_) {
                if (++this.f_9739_ > 80) {
                    f_9744_.warn("{} was kicked for floating a vehicle too long!", (Object)this.f_9743_.m_7755_().getString());
                    this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.flying")));
                    return;
                }
            } else {
                this.f_9738_ = false;
                this.f_9739_ = 0;
            }
        } else {
            this.f_9759_ = null;
            this.f_9738_ = false;
            this.f_9739_ = 0;
        }
        this.f_9745_.m_129905_().m_6180_("keepAlive");
        long i = Util.m_137550_();
        if (i - this.f_9747_ >= 25000L) {
            if (this.f_9748_) {
                this.m_9942_((Component)((Object)new TranslatableComponent("disconnect.timeout")));
            } else {
                this.f_9748_ = true;
                this.f_9747_ = i;
                this.f_9749_ = i;
                this.m_141995_((Packet<?>)new ClientboundKeepAlivePacket(this.f_9749_));
            }
        }
        this.f_9745_.m_129905_().m_7238_();
        if (this.f_9750_ > 0) {
            --this.f_9750_;
        }
        if (this.f_9751_ > 0) {
            --this.f_9751_;
        }
        if (this.f_9743_.m_8956_() > 0L && this.f_9745_.m_129924_() > 0 && Util.m_137550_() - this.f_9743_.m_8956_() > (long)(this.f_9745_.m_129924_() * 1000 * 60)) {
            this.f_9743_.m_9243_();
            this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.idling")));
        }
        SpigotTimings.playerConnectionTimer.stopTiming();
    }

    public void m_9953_() {
        this.f_9753_ = this.f_9743_.m_20185_();
        this.f_9754_ = this.f_9743_.m_20186_();
        this.f_9755_ = this.f_9743_.m_20189_();
        this.f_9756_ = this.f_9743_.m_20185_();
        this.f_9757_ = this.f_9743_.m_20186_();
        this.f_9758_ = this.f_9743_.m_20189_();
    }

    public Connection m_6198_() {
        return this.f_9742_;
    }

    private boolean m_9956_() {
        return this.f_9745_.m_7779_(this.f_9743_.m_36316_());
    }

    @Deprecated
    public void m_9942_(Component p_9943_) {
        this.disconnect(CraftChatMessage.fromComponent((Component)p_9943_));
    }

    public void disconnect(String s) {
        if (this.processedDisconnect) {
            return;
        }
        String leaveMessage = ChatFormatting.YELLOW + this.f_9743_.m_6302_() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent((org.bukkit.entity.Player)this.f_9743_.getBukkitEntity(), s, leaveMessage);
        if (this.cserver.getServer().m_130010_()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        this.f_9743_.kickLeaveMessage = event.getLeaveMessage();
        s = event.getReason();
        Component p_9943_ = CraftChatMessage.fromString((String)s, (boolean)true)[0];
        this.f_9742_.m_129514_((Packet<?>)new ClientboundDisconnectPacket(p_9943_), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_9828_ -> this.f_9742_.m_129507_(p_9943_)));
        this.m_7026_(p_9943_);
        this.f_9742_.m_129540_();
        this.f_9745_.m_6681_(this.f_9742_::m_129541_);
    }

    private <T, R> void m_9801_(T p_9802_, Consumer<R> p_9803_, BiFunction<TextFilter, T, CompletableFuture<R>> p_9804_) {
        MinecraftServer blockableeventloop = this.f_9743_.m_183503_().m_142572_();
        Consumer<Object> consumer = p_201923_ -> {
            if (this.m_6198_().m_129536_()) {
                try {
                    p_9803_.accept(p_201923_);
                }
                catch (Exception exception) {
                    f_9744_.error("Failed to handle chat packet {}, suppressing error", p_9802_, (Object)exception);
                }
            } else {
                f_9744_.debug("Ignoring packet due to disconnection");
            }
        };
        p_9804_.apply(this.f_9743_.m_8967_(), (TextFilter)p_9802_).thenAcceptAsync(consumer, (Executor)((Object)blockableeventloop));
    }

    private void m_9809_(String p_9810_, Consumer<TextFilter.FilteredText> p_9811_) {
        this.m_9801_(p_9810_, p_9811_, TextFilter::m_6770_);
    }

    private void m_9815_(List<String> p_9816_, Consumer<List<TextFilter.FilteredText>> p_9817_) {
        this.m_9801_(p_9816_, p_9817_, TextFilter::m_5925_);
    }

    public void m_5918_(ServerboundPlayerInputPacket p_9893_) {
        PacketUtils.m_131359_(p_9893_, this, this.f_9743_.m_183503_());
        this.f_9743_.m_8980_(p_9893_.m_134355_(), p_9893_.m_134358_(), p_9893_.m_134359_(), p_9893_.m_134360_());
    }

    private static boolean m_143663_(double p_143664_, double p_143665_, double p_143666_, float p_143667_, float p_143668_) {
        return Double.isNaN(p_143664_) || Double.isNaN(p_143665_) || Double.isNaN(p_143666_) || !Floats.isFinite((float)p_143668_) || !Floats.isFinite((float)p_143667_);
    }

    private static double m_143609_(double p_143610_) {
        return Mth.m_14008_((double)p_143610_, (double)-3.0E7, (double)3.0E7);
    }

    private static double m_143653_(double p_143654_) {
        return Mth.m_14008_((double)p_143654_, (double)-2.0E7, (double)2.0E7);
    }

    public void m_5659_(ServerboundMoveVehiclePacket p_9876_) {
        PacketUtils.m_131359_(p_9876_, this, this.f_9743_.m_183503_());
        if (ServerGamePacketListenerImpl.m_143663_(p_9876_.m_134199_(), p_9876_.m_134202_(), p_9876_.m_134203_(), p_9876_.m_134204_(), p_9876_.m_134205_())) {
            this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.invalid_vehicle_movement")));
        } else {
            net.minecraft.world.entity.Entity entity = this.f_9743_.m_20201_();
            if (entity != this.f_9743_ && entity.m_6688_() == this.f_9743_ && entity == this.f_9759_) {
                ServerLevel serverlevel = this.f_9743_.m_183503_();
                double d0 = entity.m_20185_();
                double d1 = entity.m_20186_();
                double d2 = entity.m_20189_();
                double d3 = ServerGamePacketListenerImpl.m_143609_(p_9876_.m_134199_());
                double d4 = ServerGamePacketListenerImpl.m_143653_(p_9876_.m_134202_());
                double d5 = ServerGamePacketListenerImpl.m_143609_(p_9876_.m_134203_());
                float f = Mth.m_14177_((float)p_9876_.m_134204_());
                float f1 = Mth.m_14177_((float)p_9876_.m_134205_());
                double d6 = d3 - this.f_9760_;
                double d7 = d4 - this.f_9761_;
                double d8 = d5 - this.f_9762_;
                double d9 = entity.m_20184_().m_82556_();
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.f_9740_;
                int i = this.f_9740_ - this.f_9741_;
                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                    f_9744_.debug(this.f_9743_.m_6302_() + " is sending move packets too frequently (" + i + " packets since last tick)");
                    i = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.f_9743_.m_150110_().f_35935_ ? (double)(this.f_9743_.m_150110_().f_35939_ * 20.0f) : (double)(this.f_9743_.m_150110_().f_35940_ * 10.0f);
                speed *= 2.0;
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.m_9956_()) {
                    f_9744_.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.m_7755_().getString(), this.f_9743_.m_7755_().getString(), d6, d7, d8});
                    this.f_9742_.m_129512_((Packet<?>)new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                boolean flag = serverlevel.m_45756_(entity, entity.m_142469_().m_82406_(0.0625));
                d6 = d3 - this.f_9763_;
                d7 = d4 - this.f_9764_ - 1.0E-6;
                d8 = d5 - this.f_9765_;
                boolean flag1 = entity.f_201939_;
                entity.m_6478_(MoverType.PLAYER, new Vec3(d6, d7, d8));
                d6 = d3 - entity.m_20185_();
                d7 = d4 - entity.m_20186_();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.m_20189_();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    f_9744_.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.m_7755_().getString(), this.f_9743_.m_7755_().getString(), Math.sqrt(d10)});
                }
                Location curPos = this.getCraftPlayer().getLocation();
                entity.m_19890_(d3, d4, d5, f, f1);
                this.f_9743_.m_19890_(d3, d4, d5, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                this.f_9743_.m_19890_(d3, d4, d5, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                boolean flag3 = serverlevel.m_45756_(entity, entity.m_142469_().m_82406_(0.0625));
                if (flag && (flag2 || !flag3)) {
                    entity.m_19890_(d0, d1, d2, f, f1);
                    this.f_9743_.m_19890_(d0, d1, d2, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                    this.f_9743_.m_19890_(d3, d4, d5, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                    this.f_9742_.m_129512_((Packet<?>)new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(p_9876_.m_134199_());
                to.setY(p_9876_.m_134202_());
                to.setZ(p_9876_.m_134203_());
                to.setYaw(p_9876_.m_134204_());
                to.setPitch(p_9876_.m_134205_());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f_9743_.m_6107_()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.f_9743_.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.f_9743_.m_183503_().m_7726_().m_8385_(this.f_9743_);
                this.f_9743_.m_36378_(this.f_9743_.m_20185_() - d0, this.f_9743_.m_20186_() - d1, this.f_9743_.m_20189_() - d2);
                this.f_9738_ = d7 >= -0.03125 && !flag1 && !this.f_9745_.m_129915_() && !entity.m_20068_() && this.m_9793_(entity);
                this.f_9763_ = entity.m_20185_();
                this.f_9764_ = entity.m_20186_();
                this.f_9765_ = entity.m_20189_();
            }
        }
    }

    private boolean m_9793_(net.minecraft.world.entity.Entity p_9794_) {
        return BlockPos.m_121921_((AABB)p_9794_.m_142469_().m_82400_(0.0625).m_82363_(0.0, -0.55, 0.0)).allMatch(b -> p_9794_.f_19853_.m_8055_((BlockPos)b).m_60795_());
    }

    public void m_7376_(ServerboundAcceptTeleportationPacket p_9835_) {
        PacketUtils.m_131359_(p_9835_, this, this.f_9743_.m_183503_());
        if (p_9835_.m_133795_() == this.f_9767_ && this.f_9766_ != null) {
            this.f_9743_.m_19890_(this.f_9766_.f_82479_, this.f_9766_.f_82480_, this.f_9766_.f_82481_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
            this.f_9756_ = this.f_9766_.f_82479_;
            this.f_9757_ = this.f_9766_.f_82480_;
            this.f_9758_ = this.f_9766_.f_82481_;
            if (this.f_9743_.m_8958_()) {
                this.f_9743_.m_8959_();
            }
            this.f_9766_ = null;
            if (this.f_9743_.valid) {
                this.f_9743_.m_183503_().m_7726_().m_8385_(this.f_9743_);
            }
        }
    }

    public void m_7411_(ServerboundRecipeBookSeenRecipePacket p_9897_) {
        PacketUtils.m_131359_(p_9897_, this, this.f_9743_.m_183503_());
        this.f_9745_.m_129894_().m_44043_(p_9897_.m_134390_()).ifPresent(arg_0 -> ((ServerRecipeBook)this.f_9743_.m_8952_()).m_12721_(arg_0));
    }

    public void m_7982_(ServerboundRecipeBookChangeSettingsPacket p_9895_) {
        PacketUtils.m_131359_(p_9895_, this, this.f_9743_.m_183503_());
        this.f_9743_.m_8952_().m_12696_(p_9895_.m_134375_(), p_9895_.m_134378_(), p_9895_.m_134379_());
    }

    public void m_6947_(ServerboundSeenAdvancementsPacket p_9903_) {
        PacketUtils.m_131359_(p_9903_, this, this.f_9743_.m_183503_());
        if (p_9903_.m_134447_() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourcelocation = p_9903_.m_134448_();
            Advancement advancement = this.f_9745_.m_129889_().m_136041_(resourcelocation);
            if (advancement != null) {
                this.f_9743_.m_8960_().m_135983_(advancement);
            }
        }
    }

    public void m_7741_(ServerboundCommandSuggestionPacket p_9847_) {
        PacketUtils.m_131359_(p_9847_, this, this.f_9743_.m_183503_());
        ++this.f_9750_;
        if (this.f_9750_ > 500 && !this.f_9745_.m_6846_().m_11303_(this.f_9743_.m_36316_())) {
            this.m_9942_((Component)((Object)new TranslatableComponent("disconnect.spam", new Object[0])));
            return;
        }
        StringReader stringreader = new StringReader(p_9847_.m_133904_());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults parseresults = this.f_9745_.m_129892_().m_82094_().parse(stringreader, (Object)this.f_9743_.m_20203_());
        this.f_9745_.m_129892_().m_82094_().getCompletionSuggestions(parseresults).thenAccept(p_143647_ -> {
            if (p_143647_.isEmpty()) {
                return;
            }
            this.f_9742_.m_129512_((Packet<?>)new ClientboundCommandSuggestionsPacket(p_9847_.m_133901_(), p_143647_));
        });
    }

    public void m_7192_(ServerboundSetCommandBlockPacket p_9911_) {
        PacketUtils.m_131359_(p_9911_, this, this.f_9743_.m_183503_());
        if (!this.f_9745_.m_6993_()) {
            this.f_9743_.m_6352_((Component)((Object)new TranslatableComponent("advMode.notEnabled")), Util.f_137441_);
        } else if (!this.f_9743_.m_36337_()) {
            this.f_9743_.m_6352_((Component)((Object)new TranslatableComponent("advMode.notAllowed")), Util.f_137441_);
        } else {
            BaseCommandBlock basecommandblock = null;
            CommandBlockEntity commandblockentity = null;
            BlockPos blockpos = p_9911_.m_134521_();
            BlockEntity blockentity = this.f_9743_.f_19853_.m_7702_(blockpos);
            if (blockentity instanceof CommandBlockEntity) {
                commandblockentity = (CommandBlockEntity)blockentity;
                basecommandblock = commandblockentity.m_59141_();
            }
            String s = p_9911_.m_134524_();
            boolean flag = p_9911_.m_134525_();
            if (basecommandblock != null) {
                CommandBlockEntity.Mode commandblockentity$mode = commandblockentity.m_59148_();
                BlockState blockstate = this.f_9743_.f_19853_.m_8055_(blockpos);
                Direction direction = (Direction)blockstate.m_61143_((Property)CommandBlock.f_51793_);
                BlockState blockstate2 = (BlockState)((Object)((BlockState)((Object)(switch (p_9911_.m_134528_()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.f_50448_.m_49966_();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.f_50447_.m_49966_();
                    default -> Blocks.f_50272_.m_49966_();
                }).m_61124_((Property)CommandBlock.f_51793_, (Comparable)direction))).m_61124_((Property)CommandBlock.f_51794_, Boolean.valueOf(p_9911_.m_134526_())));
                if (blockstate2 != blockstate) {
                    this.f_9743_.f_19853_.m_7731_(blockpos, blockstate2, 2);
                    blockentity.m_155250_(blockstate2);
                    this.f_9743_.f_19853_.m_46745_(blockpos).m_142169_(blockentity);
                }
                basecommandblock.m_6590_(s);
                basecommandblock.m_45428_(flag);
                if (!flag) {
                    basecommandblock.m_45433_(null);
                }
                commandblockentity.m_59137_(p_9911_.m_134527_());
                if (commandblockentity$mode != p_9911_.m_134528_()) {
                    commandblockentity.m_59144_();
                }
                basecommandblock.m_7368_();
                if (!StringUtil.m_14408_((String)s)) {
                    this.f_9743_.m_6352_((Component)((Object)new TranslatableComponent("advMode.setCommand.success", s)), Util.f_137441_);
                }
            }
        }
    }

    public void m_6629_(ServerboundSetCommandMinecartPacket p_9913_) {
        PacketUtils.m_131359_(p_9913_, this, this.f_9743_.m_183503_());
        if (!this.f_9745_.m_6993_()) {
            this.f_9743_.m_6352_((Component)((Object)new TranslatableComponent("advMode.notEnabled")), Util.f_137441_);
        } else if (!this.f_9743_.m_36337_()) {
            this.f_9743_.m_6352_((Component)((Object)new TranslatableComponent("advMode.notAllowed")), Util.f_137441_);
        } else {
            BaseCommandBlock basecommandblock = p_9913_.m_134537_(this.f_9743_.f_19853_);
            if (basecommandblock != null) {
                basecommandblock.m_6590_(p_9913_.m_134545_());
                basecommandblock.m_45428_(p_9913_.m_134548_());
                if (!p_9913_.m_134548_()) {
                    basecommandblock.m_45433_(null);
                }
                basecommandblock.m_7368_();
                this.f_9743_.m_6352_((Component)((Object)new TranslatableComponent("advMode.setCommand.success", p_9913_.m_134545_())), Util.f_137441_);
            }
        }
    }

    public void m_7965_(ServerboundPickItemPacket p_9880_) {
        PacketUtils.m_131359_(p_9880_, this, this.f_9743_.m_183503_());
        this.f_9743_.m_150109_().m_36038_(p_9880_.m_134232_());
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-2, 0, this.f_9743_.m_150109_().f_35977_, this.f_9743_.m_150109_().m_8020_(this.f_9743_.m_150109_().f_35977_)));
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-2, 0, p_9880_.m_134232_(), this.f_9743_.m_150109_().m_8020_(p_9880_.m_134232_())));
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundSetCarriedItemPacket(this.f_9743_.m_150109_().f_35977_));
    }

    public void m_5591_(ServerboundRenameItemPacket p_9899_) {
        PacketUtils.m_131359_(p_9899_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.f_36096_ instanceof AnvilMenu) {
            AnvilMenu anvilmenu = (AnvilMenu)this.f_9743_.f_36096_;
            String s = SharedConstants.m_136190_(p_9899_.m_134403_());
            if (s.length() <= 50) {
                anvilmenu.m_39020_(s);
            }
        }
    }

    public void m_5712_(ServerboundSetBeaconPacket p_9907_) {
        PacketUtils.m_131359_(p_9907_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.f_36096_ instanceof BeaconMenu) {
            ((BeaconMenu)this.f_9743_.f_36096_).m_39053_(p_9907_.m_134484_(), p_9907_.m_134487_());
        }
    }

    public void m_7424_(ServerboundSetStructureBlockPacket p_9919_) {
        PacketUtils.m_131359_(p_9919_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_36337_()) {
            BlockPos blockpos = p_9919_.m_134629_();
            BlockState blockstate = this.f_9743_.f_19853_.m_8055_(blockpos);
            BlockEntity blockentity = this.f_9743_.f_19853_.m_7702_(blockpos);
            if (blockentity instanceof StructureBlockEntity) {
                StructureBlockEntity structureblockentity = (StructureBlockEntity)blockentity;
                structureblockentity.m_59860_(p_9919_.m_134633_());
                structureblockentity.m_59868_(p_9919_.m_134634_());
                structureblockentity.m_59885_(p_9919_.m_134635_());
                structureblockentity.m_155797_(p_9919_.m_179787_());
                structureblockentity.m_59881_(p_9919_.m_134637_());
                structureblockentity.m_59883_(p_9919_.m_134638_());
                structureblockentity.m_59887_(p_9919_.m_134639_());
                structureblockentity.m_59876_(p_9919_.m_134640_());
                structureblockentity.m_59896_(p_9919_.m_134641_());
                structureblockentity.m_59898_(p_9919_.m_134642_());
                structureblockentity.m_59838_(p_9919_.m_134643_());
                structureblockentity.m_59840_(p_9919_.m_134644_());
                if (structureblockentity.m_59901_()) {
                    String s = structureblockentity.m_59895_();
                    if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (structureblockentity.m_59830_()) {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.save_success", s)), false);
                        } else {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.save_failure", s)), false);
                        }
                    } else if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!structureblockentity.m_59832_()) {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.load_not_found", s)), false);
                        } else if (structureblockentity.m_59842_(this.f_9743_.m_183503_())) {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.load_success", s)), false);
                        } else {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.load_prepare", s)), false);
                        }
                    } else if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (structureblockentity.m_59829_()) {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.size_success", s)), false);
                        } else {
                            this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.size_failure")), false);
                        }
                    }
                } else {
                    this.f_9743_.m_5661_((Component)((Object)new TranslatableComponent("structure_block.invalid_structure_name", p_9919_.m_134634_())), false);
                }
                structureblockentity.m_6596_();
                this.f_9743_.f_19853_.m_7260_(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void m_8019_(ServerboundSetJigsawBlockPacket p_9917_) {
        PacketUtils.m_131359_(p_9917_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_36337_()) {
            BlockPos blockpos = p_9917_.m_134585_();
            BlockState blockstate = this.f_9743_.f_19853_.m_8055_(blockpos);
            BlockEntity blockentity = this.f_9743_.f_19853_.m_7702_(blockpos);
            if (blockentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsawblockentity = (JigsawBlockEntity)blockentity;
                jigsawblockentity.m_59435_(p_9917_.m_134588_());
                jigsawblockentity.m_59438_(p_9917_.m_134589_());
                jigsawblockentity.m_59440_(p_9917_.m_134590_());
                jigsawblockentity.m_59431_(p_9917_.m_134591_());
                jigsawblockentity.m_59424_(p_9917_.m_134592_());
                jigsawblockentity.m_6596_();
                this.f_9743_.f_19853_.m_7260_(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void m_6449_(ServerboundJigsawGeneratePacket p_9868_) {
        BlockPos blockpos;
        BlockEntity blockentity;
        PacketUtils.m_131359_(p_9868_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_36337_() && (blockentity = this.f_9743_.f_19853_.m_7702_(blockpos = p_9868_.m_134087_())) instanceof JigsawBlockEntity) {
            JigsawBlockEntity jigsawblockentity = (JigsawBlockEntity)blockentity;
            jigsawblockentity.m_59420_(this.f_9743_.m_183503_(), p_9868_.m_134090_(), p_9868_.m_134091_());
        }
    }

    public void m_6321_(ServerboundSelectTradePacket p_9905_) {
        PacketUtils.m_131359_(p_9905_, this, this.f_9743_.m_183503_());
        int i = p_9905_.m_134469_();
        AbstractContainerMenu abstractcontainermenu = this.f_9743_.f_36096_;
        if (abstractcontainermenu instanceof MerchantMenu) {
            MerchantMenu merchantmenu = (MerchantMenu)abstractcontainermenu;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent((ServerPlayer)this.f_9743_, (int)i, (MerchantMenu)merchantmenu);
            if (tradeSelectEvent.isCancelled()) {
                this.f_9743_.getBukkitEntity().updateInventory();
                return;
            }
            merchantmenu.m_40063_(i);
            merchantmenu.m_40072_(i);
        }
    }

    public void m_6829_(ServerboundEditBookPacket p_9862_) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnect("Book edited too quickly!");
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i = p_9862_.m_134013_();
        if (net.minecraft.world.entity.player.Inventory.m_36045_(i) || i == 40) {
            ArrayList list = Lists.newArrayList();
            Optional optional = p_9862_.m_182761_();
            optional.ifPresent(list::add);
            p_9862_.m_182755_().stream().limit(100L).forEach(list::add);
            this.m_9815_(list, optional.isPresent() ? p_143627_ -> this.m_143630_((TextFilter.FilteredText)p_143627_.get(0), p_143627_.subList(1, p_143627_.size()), i) : p_143627_ -> this.m_9812_((List<TextFilter.FilteredText>)p_143627_, i));
        }
    }

    private void m_9812_(List<TextFilter.FilteredText> p_9813_, int p_9814_) {
        ItemStack itemstack = this.f_9743_.m_150109_().m_8020_(p_9814_);
        if (itemstack.m_150930_(Items.f_42614_)) {
            this.updateBookPages(p_9813_, UnaryOperator.identity(), itemstack.m_41777_(), p_9814_, itemstack);
        }
    }

    private void m_143630_(TextFilter.FilteredText p_143631_, List<TextFilter.FilteredText> p_143632_, int p_143633_) {
        ItemStack itemstack = this.f_9743_.m_150109_().m_8020_(p_143633_);
        if (itemstack.m_150930_(Items.f_42614_)) {
            ItemStack itemstack1 = new ItemStack(Items.f_42615_);
            CompoundTag compoundtag = itemstack.m_41783_();
            if (compoundtag != null) {
                itemstack1.m_41751_(compoundtag.m_6426_());
            }
            itemstack1.m_41700_("author", StringTag.m_129297_(this.f_9743_.m_7755_().getString()));
            if (this.f_9743_.m_143387_()) {
                itemstack1.m_41700_("title", StringTag.m_129297_(p_143631_.m_143722_()));
            } else {
                itemstack1.m_41700_("filtered_title", StringTag.m_129297_(p_143631_.m_143722_()));
                itemstack1.m_41700_("title", StringTag.m_129297_(p_143631_.m_143719_()));
            }
            this.updateBookPages(p_143632_, p_143659_ -> Component.Serializer.m_130703_((Component)new TextComponent(p_143659_)), itemstack1, p_143633_, itemstack);
            this.f_9743_.m_150109_().m_6836_(p_143633_, itemstack);
        }
    }

    private void updateBookPages(List<TextFilter.FilteredText> p_143635_, UnaryOperator<String> p_143636_, ItemStack p_143637_, int slot, ItemStack handItem) {
        ListTag listtag = new ListTag();
        if (this.f_9743_.m_143387_()) {
            p_143635_.stream().map(p_143640_ -> StringTag.m_129297_((String)p_143636_.apply(p_143640_.m_143722_()))).forEach(arg_0 -> listtag.add(arg_0));
        } else {
            CompoundTag compoundtag = new CompoundTag();
            int j = p_143635_.size();
            for (int i = 0; i < j; ++i) {
                TextFilter.FilteredText textfilter$filteredtext = p_143635_.get(i);
                String s = textfilter$filteredtext.m_143719_();
                listtag.add((Object)StringTag.m_129297_((String)p_143636_.apply(s)));
                String s1 = textfilter$filteredtext.m_143722_();
                if (s.equals(s1)) continue;
                compoundtag.m_128359_(String.valueOf(i), (String)p_143636_.apply(s1));
            }
            if (!compoundtag.m_128456_()) {
                p_143637_.m_41700_("filtered_pages", compoundtag);
            }
        }
        p_143637_.m_41700_("pages", (Tag)listtag);
        CraftEventFactory.handleEditBookEvent((ServerPlayer)this.f_9743_, (int)slot, (ItemStack)handItem, (ItemStack)p_143637_);
    }

    public void m_7548_(ServerboundEntityTagQuery p_9864_) {
        net.minecraft.world.entity.Entity entity;
        PacketUtils.m_131359_(p_9864_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_20310_(2) && (entity = this.f_9743_.m_183503_().m_6815_(p_9864_.m_134029_())) != null) {
            CompoundTag compoundtag = entity.m_20240_(new CompoundTag());
            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundTagQueryPacket(p_9864_.m_134026_(), compoundtag));
        }
    }

    public void m_6780_(ServerboundBlockEntityTagQuery p_9837_) {
        PacketUtils.m_131359_(p_9837_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_20310_(2)) {
            BlockEntity blockentity = this.f_9743_.m_183503_().m_7702_(p_9837_.m_133813_());
            CompoundTag compoundtag = blockentity != null ? blockentity.m_187482_() : null;
            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundTagQueryPacket(p_9837_.m_133810_(), compoundtag));
        }
    }

    public void m_7185_(ServerboundMovePlayerPacket p_9874_) {
        PacketUtils.m_131359_(p_9874_, this, this.f_9743_.m_183503_());
        if (ServerGamePacketListenerImpl.m_143663_(p_9874_.m_134129_(0.0), p_9874_.m_134140_(0.0), p_9874_.m_134146_(0.0), p_9874_.m_134131_(0.0f), p_9874_.m_134142_(0.0f))) {
            this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.invalid_player_movement")));
        } else {
            ServerLevel serverlevel = this.f_9743_.m_183503_();
            if (!this.f_9743_.f_8944_ && !this.f_9743_.m_6107_()) {
                if (this.f_9746_ == 0) {
                    this.m_9953_();
                }
                if (this.f_9766_ != null) {
                    if (this.f_9746_ - this.f_9735_ > 20) {
                        this.f_9735_ = this.f_9746_;
                        this.m_9774_(this.f_9766_.f_82479_, this.f_9766_.f_82480_, this.f_9766_.f_82481_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                    }
                    this.allowedPlayerTicks = 20;
                } else {
                    this.f_9735_ = this.f_9746_;
                    double d0 = ServerGamePacketListenerImpl.m_143609_(p_9874_.m_134129_(this.f_9743_.m_20185_()));
                    double d1 = ServerGamePacketListenerImpl.m_143653_(p_9874_.m_134140_(this.f_9743_.m_20186_()));
                    double d2 = ServerGamePacketListenerImpl.m_143609_(p_9874_.m_134146_(this.f_9743_.m_20189_()));
                    float f = Mth.m_14177_((float)p_9874_.m_134131_(this.f_9743_.m_146908_()));
                    float f1 = Mth.m_14177_((float)p_9874_.m_134142_(this.f_9743_.m_146909_()));
                    if (this.f_9743_.m_20159_()) {
                        this.f_9743_.m_19890_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), f, f1);
                        this.f_9743_.m_183503_().m_7726_().m_8385_(this.f_9743_);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.f_9743_.m_20185_();
                        double prevY = this.f_9743_.m_20186_();
                        double prevZ = this.f_9743_.m_20189_();
                        float prevYaw = this.f_9743_.m_146908_();
                        float prevPitch = this.f_9743_.m_146909_();
                        double d3 = this.f_9743_.m_20185_();
                        double d4 = this.f_9743_.m_20186_();
                        double d5 = this.f_9743_.m_20189_();
                        double d6 = this.f_9743_.m_20186_();
                        double d7 = d0 - this.f_9753_;
                        double d8 = d1 - this.f_9754_;
                        double d9 = d2 - this.f_9755_;
                        double d10 = this.f_9743_.m_20184_().m_82556_();
                        double d11 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (this.f_9743_.m_5803_()) {
                            if (d11 > 1.0) {
                                this.m_9774_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), f, f1);
                            }
                        } else {
                            boolean flag;
                            ++this.f_9740_;
                            int i = this.f_9740_ - this.f_9741_;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                f_9744_.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f_9743_.m_7755_().getString(), (Object)i);
                                i = 1;
                            }
                            this.allowedPlayerTicks = p_9874_.f_134125_ || d11 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.f_9743_.m_150110_().f_35935_ ? (double)(this.f_9743_.m_150110_().f_35939_ * 20.0f) : (double)(this.f_9743_.m_150110_().f_35940_ * 10.0f);
                            if (!(this.f_9743_.m_8958_() || this.f_9743_.m_183503_().m_46469_().m_46207_(GameRules.f_46148_) && this.f_9743_.m_21255_())) {
                                float f2;
                                float f3 = f2 = this.f_9743_.m_21255_() ? 300.0f : 100.0f;
                                if (d11 - d10 > Math.max((double)f2, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.m_9956_()) {
                                    f_9744_.warn("{} moved too quickly! {},{},{}", new Object[]{this.f_9743_.m_7755_().getString(), d7, d8, d9});
                                    this.m_9774_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                                    return;
                                }
                            }
                            AABB aabb = this.f_9743_.m_142469_();
                            d7 = d0 - this.f_9756_;
                            d8 = d1 - this.f_9757_;
                            d9 = d2 - this.f_9758_;
                            boolean bl = flag = d8 > 0.0;
                            if (this.f_9743_.m_20096_() && !p_9874_.m_134139_() && flag) {
                                this.f_9743_.m_6135_();
                            }
                            boolean flag1 = this.f_9743_.f_201939_;
                            this.f_9743_.m_6478_(MoverType.PLAYER, new Vec3(d7, d8, d9));
                            this.f_9743_.f_19861_ = p_9874_.m_134139_();
                            d7 = d0 - this.f_9743_.m_20185_();
                            d8 = d1 - this.f_9743_.m_20186_();
                            if (d8 > -0.5 || d8 < 0.5) {
                                d8 = 0.0;
                            }
                            d9 = d2 - this.f_9743_.m_20189_();
                            d11 = d7 * d7 + d8 * d8 + d9 * d9;
                            boolean flag2 = false;
                            if (!this.f_9743_.m_8958_() && d11 > SpigotConfig.movedWronglyThreshold && !this.f_9743_.m_5803_() && !this.f_9743_.f_8941_.m_9295_() && this.f_9743_.f_8941_.m_9290_() != GameType.SPECTATOR) {
                                flag2 = true;
                                f_9744_.warn("{} moved wrongly!", (Object)this.f_9743_.m_7755_().getString());
                            }
                            this.f_9743_.m_19890_(d0, d1, d2, f, f1);
                            if (this.f_9743_.f_19794_ || this.f_9743_.m_5803_() || (!flag2 || !serverlevel.m_45756_(this.f_9743_, aabb)) && !this.m_9795_((LevelReader)((Object)serverlevel), aabb)) {
                                this.f_9743_.m_19890_(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (p_9874_.f_134124_) {
                                    to.setX(p_9874_.f_134118_);
                                    to.setY(p_9874_.f_134119_);
                                    to.setZ(p_9874_.f_134120_);
                                }
                                if (p_9874_.f_134125_) {
                                    to.setYaw(p_9874_.f_134121_);
                                    to.setPitch(p_9874_.f_134122_);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f_9743_.m_6107_()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.f_9743_.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.f_9743_.m_19890_(d0, d1, d2, f, f1);
                                this.f_9736_ = d8 >= -0.03125 && !flag1 && this.f_9743_.f_8941_.m_9290_() != GameType.SPECTATOR && !this.f_9745_.m_129915_() && !this.f_9743_.m_150110_().f_35936_ && !this.f_9743_.m_21023_(MobEffects.f_19620_) && !this.f_9743_.m_21255_() && !this.f_9743_.m_21209_() && this.m_9793_(this.f_9743_);
                                this.f_9743_.m_183503_().m_7726_().m_8385_(this.f_9743_);
                                this.f_9743_.m_8972_(this.f_9743_.m_20186_() - d6, p_9874_.m_134139_());
                                this.f_9743_.m_6853_(p_9874_.m_134139_());
                                if (flag) {
                                    this.f_9743_.m_183634_();
                                }
                                this.f_9743_.m_36378_(this.f_9743_.m_20185_() - d3, this.f_9743_.m_20186_() - d4, this.f_9743_.m_20189_() - d5);
                                this.f_9756_ = this.f_9743_.m_20185_();
                                this.f_9757_ = this.f_9743_.m_20186_();
                                this.f_9758_ = this.f_9743_.m_20189_();
                            } else {
                                this.m_9774_(d3, d4, d5, f, f1);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean m_9795_(LevelReader p_9796_, AABB p_9797_) {
        Iterable iterable = p_9796_.m_186431_(this.f_9743_, this.f_9743_.m_142469_().m_82406_((double)1.0E-5f));
        VoxelShape voxelshape = Shapes.m_83064_(p_9797_.m_82406_((double)1.0E-5f));
        for (VoxelShape voxelshape1 : iterable) {
            if (Shapes.m_83157_(voxelshape1, voxelshape, BooleanOp.f_82689_)) continue;
            return true;
        }
        return false;
    }

    public void m_143611_(double p_143612_, double p_143613_, double p_143614_, float p_143615_, float p_143616_) {
        this.dismount(p_143612_, p_143613_, p_143614_, p_143615_, p_143616_, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void dismount(double p_143612_, double p_143613_, double p_143614_, float p_143615_, float p_143616_, PlayerTeleportEvent.TeleportCause cause) {
        this.m_143617_(p_143612_, p_143613_, p_143614_, p_143615_, p_143616_, Collections.emptySet(), true);
    }

    public void m_9774_(double p_9775_, double p_9776_, double p_9777_, float p_9778_, float p_9779_) {
        this.teleport(p_9775_, p_9776_, p_9777_, p_9778_, p_9779_, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.prepareTeleport(cause);
        this.m_143617_(d0, d1, d2, f, f1, Collections.emptySet(), false);
    }

    public void teleport(double p_9781_, double p_9782_, double p_9783_, float p_9784_, float p_9785_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_9786_, PlayerTeleportEvent.TeleportCause cause) {
        this.prepareTeleport(cause);
        this.m_143617_(p_9781_, p_9782_, p_9783_, p_9784_, p_9785_, p_9786_, false);
    }

    public void m_9780_(double p_9781_, double p_9782_, double p_9783_, float p_9784_, float p_9785_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_9786_) {
        this.resetCause();
        this.m_143617_(p_9781_, p_9782_, p_9783_, p_9784_, p_9785_, p_9786_, false);
    }

    public void prepareTeleport(PlayerTeleportEvent.TeleportCause cause) {
        this.teleportCause = cause;
    }

    public void resetCause() {
        this.teleportCause = PlayerTeleportEvent.TeleportCause.UNKNOWN;
    }

    public void m_143617_(double p_143618_, double p_143619_, double p_143620_, float p_143621_, float p_143622_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_143623_, boolean p_143624_) {
        PlayerTeleportEvent.TeleportCause tmp = this.teleportCause;
        this.resetCause();
        this.teleportResult = true;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x = p_143618_;
        double y = p_143619_;
        double z = p_143620_;
        float yaw = p_143621_;
        float pitch = p_143622_;
        Location to = new Location(this.getCraftPlayer().getWorld(), x, y, z, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(p_143618_, p_143619_, p_143620_, p_143621_, p_143622_, p_143623_, p_143624_);
            return;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((org.bukkit.entity.Player)player, from.clone(), to.clone(), tmp);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            p_143623_.clear();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            p_143618_ = to.getX();
            p_143619_ = to.getY();
            p_143620_ = to.getZ();
            p_143621_ = to.getYaw();
            p_143622_ = to.getPitch();
        }
        this.internalTeleport(p_143618_, p_143619_, p_143620_, p_143621_, p_143622_, p_143623_, p_143624_);
        this.teleportResult = event.isCancelled();
    }

    public boolean teleport(double p_143618_, double p_143619_, double p_143620_, float p_143621_, float p_143622_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_143623_, boolean p_143624_, PlayerTeleportEvent.TeleportCause cause) {
        this.prepareTeleport(cause);
        this.m_143617_(p_143618_, p_143619_, p_143620_, p_143621_, p_143622_, p_143623_, p_143624_);
        boolean result = this.teleportResult;
        this.teleportResult = true;
        return result;
    }

    public void internalTeleport(double p_143618_, double p_143619_, double p_143620_, float p_143621_, float p_143622_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_143623_, boolean p_143624_) {
        if (Float.isNaN(p_143621_)) {
            p_143621_ = 0.0f;
        }
        if (Float.isNaN(p_143622_)) {
            p_143622_ = 0.0f;
        }
        this.justTeleported = true;
        double d0 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.X) ? this.f_9743_.m_20185_() : 0.0;
        double d1 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.Y) ? this.f_9743_.m_20186_() : 0.0;
        double d2 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.Z) ? this.f_9743_.m_20189_() : 0.0;
        float f = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT) ? this.f_9743_.m_146908_() : 0.0f;
        float f1 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.X_ROT) ? this.f_9743_.m_146909_() : 0.0f;
        this.f_9766_ = new Vec3(p_143618_, p_143619_, p_143620_);
        if (++this.f_9767_ == Integer.MAX_VALUE) {
            this.f_9767_ = 0;
        }
        this.lastPosX = this.f_9766_.f_82479_;
        this.lastPosY = this.f_9766_.f_82480_;
        this.lastPosZ = this.f_9766_.f_82481_;
        this.lastYaw = f;
        this.lastPitch = f1;
        this.f_9735_ = this.f_9746_;
        this.f_9743_.m_19890_(p_143618_, p_143619_, p_143620_, p_143621_, p_143622_);
        this.f_9743_.f_8906_.m_141995_(new ClientboundPlayerPositionPacket(p_143618_ - d0, p_143619_ - d1, p_143620_ - d2, p_143621_ - f, p_143622_ - f1, p_143623_, this.f_9767_, p_143624_));
    }

    public void m_7502_(ServerboundPlayerActionPacket p_9889_) {
        PacketUtils.m_131359_(p_9889_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        BlockPos blockpos = p_9889_.m_134281_();
        this.f_9743_.m_9243_();
        ServerboundPlayerActionPacket.Action serverboundplayeractionpacket$action = p_9889_.m_134285_();
        switch (serverboundplayeractionpacket$action) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.f_9743_.m_5833_()) {
                    ItemStack itemstack = this.f_9743_.m_21120_(InteractionHand.OFF_HAND);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror((ItemStack)itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror((ItemStack)this.f_9743_.m_21120_(InteractionHand.MAIN_HAND));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.f_9743_.m_21008_(InteractionHand.OFF_HAND, this.f_9743_.m_21120_(InteractionHand.MAIN_HAND));
                    } else {
                        this.f_9743_.m_21008_(InteractionHand.OFF_HAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.f_9743_.m_21008_(InteractionHand.MAIN_HAND, itemstack);
                    } else {
                        this.f_9743_.m_21008_(InteractionHand.MAIN_HAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)swapItemsEvent.getMainHandItem()));
                    }
                    this.f_9743_.m_5810_();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.f_9743_.m_5833_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            f_9744_.warn(this.f_9743_.m_6302_() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)");
                            return;
                        }
                    }
                    this.f_9743_.m_182294_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.f_9743_.m_5833_()) {
                    this.f_9743_.m_182294_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.f_9743_.m_21253_();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.f_9743_.f_8941_.m_7391_(blockpos, serverboundplayeractionpacket$action, p_9889_.m_134284_(), this.f_9743_.f_19853_.m_151558_());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean m_9790_(ServerPlayer p_9791_, ItemStack p_9792_) {
        if (p_9792_.m_41619_()) {
            return false;
        }
        Item item = p_9792_.m_41720_();
        return (item instanceof BlockItem || item instanceof BucketItem) && !p_9791_.m_36335_().m_41519_(item);
    }

    public void m_6371_(ServerboundUseItemOnPacket p_9930_) {
        PacketUtils.m_131359_(p_9930_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (!this.checkLimit(p_9930_.timestamp)) {
            return;
        }
        ServerLevel serverlevel = this.f_9743_.m_183503_();
        InteractionHand interactionhand = p_9930_.m_134703_();
        ItemStack itemstack = this.f_9743_.m_21120_(interactionhand);
        BlockHitResult blockhitresult = p_9930_.m_134706_();
        Vec3 vec3 = blockhitresult.m_82450_();
        BlockPos blockpos = blockhitresult.m_82425_();
        Vec3 vec31 = vec3.m_82546_(Vec3.m_82512_((Vec3i)blockpos));
        if (this.f_9743_.f_19853_.m_142572_() != null && this.f_9743_.m_146902_().m_45594_(new ChunkPos(blockpos)) < this.f_9743_.f_19853_.spigotConfig.viewDistance) {
            double d0 = 1.0000001;
            if (Math.abs(vec31.m_7096_()) < 1.0000001 && Math.abs(vec31.m_7098_()) < 1.0000001 && Math.abs(vec31.m_7094_()) < 1.0000001) {
                Direction direction = blockhitresult.m_82434_();
                this.f_9743_.m_9243_();
                int i = this.f_9743_.f_19853_.m_151558_();
                if (blockpos.m_123342_() < i) {
                    if (this.f_9766_ == null && this.f_9743_.m_20275_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5) < 64.0 && serverlevel.m_7966_(this.f_9743_, blockpos)) {
                        this.f_9743_.m_5810_();
                        InteractionResult interactionresult = this.f_9743_.f_8941_.m_7179_(this.f_9743_, serverlevel, itemstack, interactionhand, blockhitresult);
                        if (direction == Direction.UP && !interactionresult.m_19077_() && blockpos.m_123342_() >= i - 1 && ServerGamePacketListenerImpl.m_9790_(this.f_9743_, itemstack)) {
                            MutableComponent component = new TranslatableComponent("build.tooHigh", i - 1).m_130940_(ChatFormatting.RED);
                            this.f_9743_.m_9146_((Component)component, ChatType.GAME_INFO, Util.f_137441_);
                        } else if (interactionresult.m_19080_()) {
                            this.f_9743_.m_21011_(interactionhand, true);
                        }
                    }
                } else {
                    MutableComponent component1 = new TranslatableComponent("build.tooHigh", i - 1).m_130940_(ChatFormatting.RED);
                    this.f_9743_.m_9146_((Component)component1, ChatType.GAME_INFO, Util.f_137441_);
                }
                this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)((Object)serverlevel), blockpos));
                this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)((Object)serverlevel), blockpos.m_142300_(direction)));
            } else {
                f_9744_.warn("Ignoring UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f_9743_.m_36316_().getName(), vec3, blockpos});
            }
        } else {
            f_9744_.warn("Ignoring UseItemOnPacket from {}: hit position {} too far away from player {}.", new Object[]{this.f_9743_.m_36316_().getName(), blockpos, this.f_9743_.m_142538_()});
        }
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    public void m_5760_(ServerboundUseItemPacket p_9932_) {
        PacketUtils.m_131359_(p_9932_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (!this.checkLimit(p_9932_.timestamp)) {
            return;
        }
        ServerLevel serverlevel = this.f_9743_.m_183503_();
        InteractionHand interactionhand = p_9932_.m_134717_();
        ItemStack itemstack = this.f_9743_.m_21120_(interactionhand);
        this.f_9743_.m_9243_();
        if (!itemstack.m_41619_()) {
            boolean cancelled;
            float f1 = this.f_9743_.m_146909_();
            float f2 = this.f_9743_.m_146908_();
            double d0 = this.f_9743_.m_20185_();
            double d1 = this.f_9743_.m_20186_() + (double)this.f_9743_.m_20192_();
            double d2 = this.f_9743_.m_20189_();
            Vec3 vec3d = new Vec3(d0, d1, d2);
            float f3 = Mth.m_14089_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = Mth.m_14031_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.f_9743_.f_8941_.m_9290_() == GameType.CREATIVE ? 5.0 : 4.5;
            Vec3 vec3d1 = vec3d.m_82520_((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            BlockHitResult movingobjectposition = this.f_9743_.f_19853_.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, this.f_9743_));
            if (movingobjectposition == null || movingobjectposition.m_6662_() != HitResult.Type.BLOCK) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)this.f_9743_, (Action)Action.RIGHT_CLICK_AIR, (ItemStack)itemstack, (InteractionHand)interactionhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                BlockHitResult movingobjectpositionblock = movingobjectposition;
                cancelled = this.f_9743_.f_8941_.firedInteract && this.f_9743_.f_8941_.interactPosition.equals((Object)movingobjectpositionblock.m_82425_()) && this.f_9743_.f_8941_.interactHand == interactionhand && ItemStack.m_41658_(this.f_9743_.f_8941_.interactItemStack, itemstack) ? this.f_9743_.f_8941_.interactResult : (event = CraftEventFactory.callPlayerInteractEvent((Player)this.f_9743_, (Action)Action.RIGHT_CLICK_BLOCK, (BlockPos)movingobjectpositionblock.m_82425_(), (Direction)movingobjectpositionblock.m_82434_(), (ItemStack)itemstack, (boolean)true, (InteractionHand)interactionhand)).useItemInHand() == Event.Result.DENY;
                this.f_9743_.f_8941_.firedInteract = false;
            }
            if (cancelled) {
                this.f_9743_.getBukkitEntity().updateInventory();
                return;
            }
            InteractionResult interactionresult = this.f_9743_.f_8941_.m_6261_(this.f_9743_, serverlevel, itemstack, interactionhand);
            if (interactionresult.m_19080_()) {
                this.f_9743_.m_21011_(interactionhand, true);
            }
        }
    }

    public void m_6936_(ServerboundTeleportToEntityPacket p_9928_) {
        PacketUtils.m_131359_(p_9928_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_5833_()) {
            for (ServerLevel serverlevel : this.f_9745_.m_129785_()) {
                net.minecraft.world.entity.Entity entity = p_9928_.m_134681_(serverlevel);
                if (entity == null) continue;
                this.f_9743_.teleportTo(serverlevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    public void m_7529_(ServerboundResourcePackPacket p_9901_) {
        PacketUtils.m_131359_(p_9901_, this, this.f_9743_.m_183503_());
        if (p_9901_.m_179741_() == ServerboundResourcePackPacket.Action.DECLINED && this.f_9745_.m_142205_()) {
            f_9744_.info("Disconnecting {} due to resource pack rejection", (Object)this.f_9743_.m_7755_());
            this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.requiredTexturePrompt.disconnect")));
        }
    }

    public void m_5938_(ServerboundPaddleBoatPacket p_9878_) {
        PacketUtils.m_131359_(p_9878_, this, this.f_9743_.m_183503_());
        net.minecraft.world.entity.Entity entity = this.f_9743_.m_20202_();
        if (entity instanceof Boat) {
            ((Boat)entity).m_38339_(p_9878_.m_134218_(), p_9878_.m_134221_());
        }
    }

    public void m_142110_(ServerboundPongPacket p_143652_) {
    }

    public void m_7026_(Component p_9825_) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        f_9744_.info("{} lost connection: {}", (Object)this.f_9743_.m_7755_().getString(), (Object)p_9825_.getString());
        this.f_9743_.m_9231_();
        String quitMessage = this.f_9745_.m_6846_().removeAndReturn(this.f_9743_);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.f_9745_.m_6846_().broadcastMessage(CraftChatMessage.fromString((String)quitMessage));
        }
        this.f_9743_.m_8967_().m_7670_();
        if (this.m_9956_()) {
            f_9744_.info("Stopping singleplayer server as player logged out");
            this.f_9745_.m_7570_(false);
        }
    }

    public void m_141995_(Packet<?> p_9830_) {
        this.m_9831_(p_9830_, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void m_9831_(Packet<?> p_9832_, @Nullable GenericFutureListener<? extends Future<? super Void>> p_9833_) {
        if (p_9832_ == null || this.processedDisconnect) {
            return;
        }
        if (p_9832_ instanceof ClientboundSetDefaultSpawnPositionPacket) {
            ClientboundSetDefaultSpawnPositionPacket packet6 = (ClientboundSetDefaultSpawnPositionPacket)p_9832_;
            this.f_9743_.compassTarget = new Location(this.getCraftPlayer().getWorld(), (double)packet6.f_133111_.m_123341_(), (double)packet6.f_133111_.m_123342_(), (double)packet6.f_133111_.m_123343_());
        }
        try {
            this.f_9742_.m_129514_(p_9832_, p_9833_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Packet being sent");
            crashreportcategory.m_128165_("Packet class", (CrashReportDetail<String>)((CrashReportDetail)() -> p_9832_.getClass().getCanonicalName()));
            throw new ReportedException(crashreport);
        }
    }

    public void m_7798_(ServerboundSetCarriedItemPacket p_9909_) {
        PacketUtils.m_131359_(p_9909_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (p_9909_.m_134498_() >= 0 && p_9909_.m_134498_() < net.minecraft.world.entity.player.Inventory.m_36059_()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((org.bukkit.entity.Player)this.getCraftPlayer(), this.f_9743_.m_150109_().f_35977_, p_9909_.m_134498_());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.m_141995_((Packet<?>)new ClientboundSetCarriedItemPacket(this.f_9743_.m_150109_().f_35977_));
                this.f_9743_.m_9243_();
                return;
            }
            if (this.f_9743_.m_150109_().f_35977_ != p_9909_.m_134498_() && this.f_9743_.m_7655_() == InteractionHand.MAIN_HAND) {
                this.f_9743_.m_5810_();
            }
            this.f_9743_.m_150109_().f_35977_ = p_9909_.m_134498_();
            this.f_9743_.m_9243_();
        } else {
            f_9744_.warn("{} tried to set an invalid carried item", (Object)this.f_9743_.m_7755_().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)");
        }
    }

    public void m_7388_(ServerboundChatPacket p_9841_) {
        if (this.f_9745_.m_129918_()) {
            return;
        }
        String s = StringUtils.normalizeSpace((String)p_9841_.m_133837_());
        for (int i = 0; i < s.length(); ++i) {
            if (SharedConstants.m_136188_(s.charAt(i))) continue;
            this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.illegal_characters")));
            return;
        }
        if (s.startsWith("/")) {
            PacketUtils.m_131359_(p_9841_, this, this.f_9743_.m_183503_());
            this.m_143628_(TextFilter.FilteredText.m_143720_((String)s));
        } else {
            this.m_143628_(TextFilter.FilteredText.m_143720_((String)s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m_143628_(TextFilter.FilteredText p_143629_) {
        if (this.f_9743_.m_146910_() || this.f_9743_.m_9241_() == ChatVisiblity.HIDDEN) {
            this.m_141995_(new ClientboundChatPacket((Component)new TranslatableComponent("chat.disabled.options").m_130940_(ChatFormatting.RED), ChatType.SYSTEM, Util.f_137441_));
        } else {
            this.f_9743_.m_9243_();
            String s = p_143629_.m_143719_();
            boolean isSync = s.startsWith("/");
            if (isSync) {
                try {
                    this.f_9745_.server.playerCommandState = true;
                    this.m_9957_(s);
                }
                finally {
                    this.f_9745_.server.playerCommandState = false;
                }
            } else if (s.isEmpty()) {
                f_9744_.warn(this.f_9743_.m_7755_() + " tried to send an empty message");
            } else if (this.getCraftPlayer().isConversing()) {
                final String conversationInput = s;
                this.f_9745_.processQueue.add(new Runnable(){

                    @Override
                    public void run() {
                        ServerGamePacketListenerImpl.this.getCraftPlayer().acceptConversationInput(conversationInput);
                    }
                });
            } else if (this.f_9743_.m_9241_() == ChatVisiblity.SYSTEM) {
                this.m_141995_(new ClientboundChatPacket((Component)new TranslatableComponent("chat.cannotSend").m_130940_(ChatFormatting.RED), ChatType.SYSTEM, Util.f_137441_));
            } else {
                this.chat(s, true);
            }
            boolean counted = true;
            for (String exclude : SpigotConfig.spamExclusions) {
                if (exclude == null || !s.startsWith(exclude)) continue;
                counted = false;
                break;
            }
            this.f_9750_ += 20;
            if (this.f_9750_ > 200 && !this.f_9745_.m_6846_().m_11303_(this.f_9743_.m_36316_())) {
                if (!isSync) {
                    Waitable waitable = new Waitable(){

                        protected Object evaluate() {
                            ServerGamePacketListenerImpl.this.m_9942_((Component)((Object)new TranslatableComponent("disconnect.spam")));
                            return null;
                        }
                    };
                    this.f_9745_.processQueue.add((Runnable)waitable);
                    try {
                        waitable.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.m_9942_((Component)((Object)new TranslatableComponent("disconnect.spam")));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m_9957_(String p_9958_) {
        SpigotTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            f_9744_.info(this.f_9743_.m_6302_() + " issued server command: " + p_9958_);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)player, p_9958_, (Set)new LazyPlayerSet(this.f_9745_));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            SpigotTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(ServerGamePacketListenerImpl.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            SpigotTimings.playerCommandTimer.stopTiming();
        }
    }

    public void m_7953_(ServerboundSwingPacket p_9926_) {
        PacketUtils.m_131359_(p_9926_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        float f1 = this.f_9743_.m_146909_();
        float f2 = this.f_9743_.m_146908_();
        double d0 = this.f_9743_.m_20185_();
        double d1 = this.f_9743_.m_20186_() + (double)this.f_9743_.m_20192_();
        double d2 = this.f_9743_.m_20189_();
        Vec3 vec3d = new Vec3(d0, d1, d2);
        float f3 = Mth.m_14089_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = Mth.m_14031_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = this.f_9743_.f_8941_.m_9290_() == GameType.CREATIVE ? 5.0 : 4.5;
        Vec3 vec3d1 = vec3d.m_82520_((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        BlockHitResult movingobjectposition = this.f_9743_.f_19853_.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, this.f_9743_));
        if (movingobjectposition == null || movingobjectposition.m_6662_() != HitResult.Type.BLOCK) {
            CraftEventFactory.callPlayerInteractEvent((Player)this.f_9743_, (Action)Action.LEFT_CLICK_AIR, (ItemStack)this.f_9743_.m_150109_().m_36056_(), (InteractionHand)InteractionHand.MAIN_HAND);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((org.bukkit.entity.Player)this.getCraftPlayer());
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f_9743_.m_6674_(p_9926_.m_134674_());
    }

    public void m_5681_(ServerboundPlayerCommandPacket p_9891_) {
        PacketUtils.m_131359_(p_9891_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_146910_()) {
            return;
        }
        switch (p_9891_.m_134320_()) {
            case PRESS_SHIFT_KEY: 
            case RELEASE_SHIFT_KEY: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((org.bukkit.entity.Player)this.getCraftPlayer(), p_9891_.m_134320_() == ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case START_SPRINTING: 
            case STOP_SPRINTING: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((org.bukkit.entity.Player)this.getCraftPlayer(), p_9891_.m_134320_() == ServerboundPlayerCommandPacket.Action.START_SPRINTING);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.f_9743_.m_9243_();
        switch (p_9891_.m_134320_()) {
            case PRESS_SHIFT_KEY: {
                this.f_9743_.m_20260_(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.f_9743_.m_20260_(false);
                break;
            }
            case START_SPRINTING: {
                this.f_9743_.m_6858_(true);
                break;
            }
            case STOP_SPRINTING: {
                this.f_9743_.m_6858_(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.f_9743_.m_5803_()) break;
                this.f_9743_.m_6145_(false, true);
                this.f_9766_ = this.f_9743_.m_20182_();
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.f_9743_.m_20202_() instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping playerrideablejumping1 = (PlayerRideableJumping)this.f_9743_.m_20202_();
                int i = p_9891_.m_134321_();
                if (!playerrideablejumping1.m_7132_() || i <= 0) break;
                playerrideablejumping1.m_7199_(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.f_9743_.m_20202_() instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping playerrideablejumping = (PlayerRideableJumping)this.f_9743_.m_20202_();
                playerrideablejumping.m_8012_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.f_9743_.m_20202_() instanceof AbstractHorse)) break;
                ((AbstractHorse)this.f_9743_.m_20202_()).m_30620_(this.f_9743_);
                break;
            }
            case START_FALL_FLYING: {
                if (this.f_9743_.m_36319_()) break;
                this.f_9743_.m_36321_();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    public void m_6946_(ServerboundInteractPacket p_9866_) {
        PacketUtils.m_131359_(p_9866_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        ServerLevel serverlevel = this.f_9743_.m_183503_();
        final net.minecraft.world.entity.Entity entity = p_9866_.m_179603_(serverlevel);
        if (entity == this.f_9743_ && !this.f_9743_.m_5833_()) {
            this.disconnect("Cannot interact with self!");
            return;
        }
        this.f_9743_.m_9243_();
        this.f_9743_.m_20260_(p_9866_.m_134061_());
        if (entity != null) {
            if (!serverlevel.m_6857_().m_61937_(entity.m_142538_())) {
                return;
            }
            double d0 = 36.0;
            if (this.f_9743_.m_20280_(entity) < 36.0) {
                p_9866_.m_179617_(new ServerboundInteractPacket.Handler(){

                    private void performInteraction(InteractionHand p_143679_, EntityInteraction p_143680_, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = ServerGamePacketListenerImpl.this.f_9743_.m_21120_(p_143679_).m_41777_();
                        ItemStack itemInHand = ServerGamePacketListenerImpl.this.f_9743_.m_21120_(p_143679_);
                        boolean triggerLeashUpdate = itemInHand != null && itemInHand.m_41720_() == Items.f_42655_ && entity instanceof Mob;
                        Item origItem = ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null ? null : ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_();
                        ServerGamePacketListenerImpl.this.cserver.getPluginManager().callEvent((Event)event);
                        if (entity instanceof Bucketable && entity instanceof LivingEntity && origItem != null && origItem.m_5456_() == Items.f_42447_ && (event.isCancelled() || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_() != origItem)) {
                            ServerGamePacketListenerImpl.this.m_141995_((Packet<?>)new ClientboundAddMobPacket((LivingEntity)entity));
                            ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                        }
                        if (triggerLeashUpdate && (event.isCancelled() || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_() != origItem)) {
                            ServerGamePacketListenerImpl.this.m_141995_((Packet<?>)new ClientboundSetEntityLinkPacket(entity, ((Mob)entity).m_21524_()));
                        }
                        if (event.isCancelled() || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_() != origItem) {
                            ServerGamePacketListenerImpl.this.m_141995_((Packet<?>)new ClientboundSetEntityDataPacket(entity.m_142049_(), entity.m_20088_(), true));
                        }
                        if (event.isCancelled()) {
                            return;
                        }
                        InteractionResult interactionresult = p_143680_.m_143694_(ServerGamePacketListenerImpl.this.f_9743_, entity, p_143679_);
                        if (!itemInHand.m_41619_() && itemInHand.m_41613_() <= -1) {
                            ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                        }
                        if (interactionresult.m_19077_()) {
                            CriteriaTriggers.f_10565_.m_61494_(ServerGamePacketListenerImpl.this.f_9743_, itemstack, entity);
                            if (interactionresult.m_19080_()) {
                                ServerGamePacketListenerImpl.this.f_9743_.m_21011_(p_143679_, true);
                            }
                        }
                    }

                    public void m_142299_(InteractionHand p_143677_) {
                        this.performInteraction(p_143677_, Player::m_36157_, new PlayerInteractEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), p_143677_ == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    public void m_142143_(InteractionHand p_143682_, Vec3 p_143683_) {
                        this.performInteraction(p_143682_, (p_143686_, p_143687_, p_143688_) -> p_143687_.m_7111_(p_143686_, p_143683_, p_143688_), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(p_143683_.f_82479_, p_143683_.f_82480_, p_143683_.f_82481_), p_143682_ == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    public void m_141994_() {
                        if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == ServerGamePacketListenerImpl.this.f_9743_ && !ServerGamePacketListenerImpl.this.f_9743_.m_5833_())) {
                            ItemStack itemInHand = ServerGamePacketListenerImpl.this.f_9743_.m_21205_();
                            ServerGamePacketListenerImpl.this.f_9743_.m_5706_(entity);
                            if (!itemInHand.m_41619_() && itemInHand.m_41613_() <= -1) {
                                ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                            }
                        } else {
                            ServerGamePacketListenerImpl.this.m_9942_((Component)((Object)new TranslatableComponent("multiplayer.disconnect.invalid_entity_attacked")));
                            f_9744_.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.f_9743_.m_7755_().getString());
                        }
                    }
                });
            }
        }
    }

    public void m_6272_(ServerboundClientCommandPacket p_9843_) {
        PacketUtils.m_131359_(p_9843_, this, this.f_9743_.m_183503_());
        this.f_9743_.m_9243_();
        ServerboundClientCommandPacket.Action serverboundclientcommandpacket$action = p_9843_.m_133850_();
        switch (serverboundclientcommandpacket$action) {
            case PERFORM_RESPAWN: {
                if (this.f_9743_.f_8944_) {
                    this.f_9743_.f_8944_ = false;
                    this.f_9743_ = this.f_9745_.m_6846_().m_11236_(this.f_9743_, true);
                    CriteriaTriggers.f_10588_.m_19757_(this.f_9743_, net.minecraft.world.level.Level.f_46430_, net.minecraft.world.level.Level.f_46428_);
                    break;
                }
                if (this.f_9743_.m_21223_() > 0.0f) {
                    return;
                }
                this.f_9743_ = this.f_9745_.m_6846_().m_11236_(this.f_9743_, false);
                if (!this.f_9745_.m_7035_()) break;
                this.f_9743_.m_143403_(GameType.SPECTATOR);
                ((GameRules.BooleanValue)this.f_9743_.m_183503_().m_46469_().m_46170_(GameRules.f_46146_)).m_46246_(false, this.f_9745_);
                break;
            }
            case REQUEST_STATS: {
                this.f_9743_.m_8951_().m_12819_(this.f_9743_);
            }
        }
    }

    public void m_7951_(ServerboundContainerClosePacket p_9858_) {
        PacketUtils.m_131359_(p_9858_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9230_();
    }

    public void m_5914_(ServerboundContainerClickPacket p_9856_) {
        PacketUtils.m_131359_(p_9856_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        if (this.f_9743_.f_36096_.f_38840_ == p_9856_.m_133959_() && this.f_9743_.f_36096_.m_6875_(this.f_9743_)) {
            boolean cancelled = this.f_9743_.m_5833_();
            int i = p_9856_.m_133962_();
            if (!this.f_9743_.f_36096_.m_207775_(i)) {
                f_9744_.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f_9743_.m_7755_(), i, this.f_9743_.f_36096_.f_38839_.size()});
            } else {
                boolean flag = p_9856_.m_182741_() != this.f_9743_.f_36096_.m_182424_();
                this.f_9743_.f_36096_.m_150443_();
                if (p_9856_.m_133962_() < -1 && p_9856_.m_133962_() != -999) {
                    return;
                }
                InventoryViewHelper.captureContainerOwner((Player)this.f_9743_);
                InventoryView inventory = this.f_9743_.f_36096_.getBukkitView();
                InventoryViewHelper.resetContainerOwner();
                InventoryType.SlotType type = inventory.getSlotType(p_9856_.m_133962_());
                org.bukkit.event.inventory.ClickType click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                InventoryAction action = InventoryAction.UNKNOWN;
                ItemStack itemstack = ItemStack.f_41583_;
                switch (p_9856_.m_133966_()) {
                    case PICKUP: {
                        if (p_9856_.m_133963_() == 0) {
                            click = org.bukkit.event.inventory.ClickType.LEFT;
                        } else if (p_9856_.m_133963_() == 1) {
                            click = org.bukkit.event.inventory.ClickType.RIGHT;
                        }
                        if (p_9856_.m_133963_() != 0 && p_9856_.m_133963_() != 1) break;
                        action = InventoryAction.NOTHING;
                        if (p_9856_.m_133962_() == -999) {
                            if (this.f_9743_.f_36096_.m_142621_().m_41619_()) break;
                            action = p_9856_.m_133963_() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                            break;
                        }
                        if (p_9856_.m_133962_() < 0) {
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        Slot slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                        if (slot == null) break;
                        ItemStack clickedItem = slot.m_7993_();
                        ItemStack cursor = this.f_9743_.f_36096_.m_142621_();
                        if (clickedItem.m_41619_()) {
                            if (cursor.m_41619_()) break;
                            action = p_9856_.m_133963_() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                            break;
                        }
                        if (!slot.m_8010_(this.f_9743_)) break;
                        if (cursor.m_41619_()) {
                            action = p_9856_.m_133963_() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                            break;
                        }
                        if (slot.m_5857_(cursor)) {
                            if (clickedItem.m_41656_(cursor) && ItemStack.m_41658_(clickedItem, cursor)) {
                                int toPlace = p_9856_.m_133963_() == 0 ? cursor.m_41613_() : 1;
                                toPlace = Math.min(toPlace, clickedItem.m_41741_() - clickedItem.m_41613_());
                                if ((toPlace = Math.min(toPlace, slot.f_40218_.m_6893_() - clickedItem.m_41613_())) == 1) {
                                    action = InventoryAction.PLACE_ONE;
                                    break;
                                }
                                if (toPlace == cursor.m_41613_()) {
                                    action = InventoryAction.PLACE_ALL;
                                    break;
                                }
                                if (toPlace < 0) {
                                    action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                    break;
                                }
                                if (toPlace == 0) break;
                                action = InventoryAction.PLACE_SOME;
                                break;
                            }
                            if (cursor.m_41613_() > slot.m_6641_()) break;
                            action = InventoryAction.SWAP_WITH_CURSOR;
                            break;
                        }
                        if (cursor.m_41720_() != clickedItem.m_41720_() || !ItemStack.m_41658_(cursor, clickedItem) || clickedItem.m_41613_() < 0 || clickedItem.m_41613_() + cursor.m_41613_() > cursor.m_41741_()) break;
                        action = InventoryAction.PICKUP_ALL;
                        break;
                    }
                    case QUICK_MOVE: {
                        if (p_9856_.m_133963_() == 0) {
                            click = org.bukkit.event.inventory.ClickType.SHIFT_LEFT;
                        } else if (p_9856_.m_133963_() == 1) {
                            click = org.bukkit.event.inventory.ClickType.SHIFT_RIGHT;
                        }
                        if (p_9856_.m_133963_() != 0 && p_9856_.m_133963_() != 1) break;
                        if (p_9856_.m_133962_() < 0) {
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        Slot slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                        if (slot != null && slot.m_8010_(this.f_9743_) && slot.m_6657_()) {
                            action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    case SWAP: {
                        if ((p_9856_.m_133963_() < 0 || p_9856_.m_133963_() >= 9) && p_9856_.m_133963_() != 40) break;
                        click = p_9856_.m_133963_() == 40 ? org.bukkit.event.inventory.ClickType.SWAP_OFFHAND : org.bukkit.event.inventory.ClickType.NUMBER_KEY;
                        Slot clickedSlot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                        if (clickedSlot.m_8010_(this.f_9743_)) {
                            boolean canCleanSwap;
                            ItemStack hotbar = this.f_9743_.m_150109_().m_8020_(p_9856_.m_133963_());
                            boolean bl = canCleanSwap = hotbar.m_41619_() || clickedSlot.f_40218_ == this.f_9743_.m_150109_() && clickedSlot.m_5857_(hotbar);
                            if (clickedSlot.m_6657_()) {
                                if (canCleanSwap) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                break;
                            }
                            if (!clickedSlot.m_6657_() && !hotbar.m_41619_() && clickedSlot.m_5857_(hotbar)) {
                                action = InventoryAction.HOTBAR_SWAP;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    case CLONE: {
                        Slot slot;
                        if (p_9856_.m_133963_() == 2) {
                            click = org.bukkit.event.inventory.ClickType.MIDDLE;
                            if (p_9856_.m_133962_() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                            if (slot != null && slot.m_6657_() && this.f_9743_.m_150110_().f_35937_ && this.f_9743_.f_36096_.m_142621_().m_41619_()) {
                                action = InventoryAction.CLONE_STACK;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                        action = InventoryAction.UNKNOWN;
                        break;
                    }
                    case THROW: {
                        Slot slot;
                        if (p_9856_.m_133962_() >= 0) {
                            if (p_9856_.m_133963_() == 0) {
                                click = org.bukkit.event.inventory.ClickType.DROP;
                                slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                                if (slot != null && slot.m_6657_() && slot.m_8010_(this.f_9743_) && !slot.m_7993_().m_41619_() && slot.m_7993_().m_41720_() != Item.m_41439_(Blocks.f_50016_)) {
                                    action = InventoryAction.DROP_ONE_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            if (p_9856_.m_133963_() != 1) break;
                            click = org.bukkit.event.inventory.ClickType.CONTROL_DROP;
                            slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                            if (slot != null && slot.m_6657_() && slot.m_8010_(this.f_9743_) && !slot.m_7993_().m_41619_() && slot.m_7993_().m_41720_() != Item.m_41439_(Blocks.f_50016_)) {
                                action = InventoryAction.DROP_ALL_SLOT;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        click = org.bukkit.event.inventory.ClickType.LEFT;
                        if (p_9856_.m_133963_() == 1) {
                            click = org.bukkit.event.inventory.ClickType.RIGHT;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    case QUICK_CRAFT: {
                        this.f_9743_.f_36096_.m_150399_(p_9856_.m_133962_(), p_9856_.m_133963_(), p_9856_.m_133966_(), this.f_9743_);
                        break;
                    }
                    case PICKUP_ALL: {
                        click = org.bukkit.event.inventory.ClickType.DOUBLE_CLICK;
                        action = InventoryAction.NOTHING;
                        if (p_9856_.m_133962_() < 0 || this.f_9743_.f_36096_.m_142621_().m_41619_()) break;
                        ItemStack cursor = this.f_9743_.f_36096_.m_142621_();
                        action = InventoryAction.NOTHING;
                        if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial((Item)cursor.m_41720_())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial((Item)cursor.m_41720_()))) break;
                        action = InventoryAction.COLLECT_TO_CURSOR;
                        break;
                    }
                }
                if (p_9856_.m_133966_() != ClickType.QUICK_CRAFT) {
                    org.bukkit.inventory.ItemStack result;
                    org.bukkit.inventory.Recipe recipe;
                    InventoryClickEvent event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, p_9856_.m_133962_(), click, action, p_9856_.m_133963_()) : new InventoryClickEvent(inventory, type, p_9856_.m_133962_(), click, action);
                    Inventory top = inventory.getTopInventory();
                    if (p_9856_.m_133962_() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                        event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, p_9856_.m_133962_(), click, action, p_9856_.m_133963_()) : new CraftItemEvent(recipe, inventory, type, p_9856_.m_133962_(), click, action);
                    }
                    if (p_9856_.m_133962_() == 2 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                        event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, p_9856_.m_133962_(), click, action, p_9856_.m_133963_()) : new SmithItemEvent(inventory, type, p_9856_.m_133962_(), click, action);
                    }
                    event.setCancelled(cancelled);
                    AbstractContainerMenu oldContainer = this.f_9743_.f_36096_;
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (this.f_9743_.f_36096_ != oldContainer) {
                        return;
                    }
                    block9 : switch (event.getResult()) {
                        case ALLOW: 
                        case DEFAULT: {
                            this.f_9743_.f_36096_.m_150399_(i, p_9856_.m_133963_(), p_9856_.m_133966_(), this.f_9743_);
                            break;
                        }
                        case DENY: {
                            switch (action) {
                                case PICKUP_ALL: 
                                case MOVE_TO_OTHER_INVENTORY: 
                                case HOTBAR_MOVE_AND_READD: 
                                case HOTBAR_SWAP: 
                                case COLLECT_TO_CURSOR: 
                                case UNKNOWN: {
                                    this.f_9743_.f_36096_.m_150429_();
                                    break block9;
                                }
                                case PICKUP_SOME: 
                                case PICKUP_HALF: 
                                case PICKUP_ONE: 
                                case PLACE_ALL: 
                                case PLACE_SOME: 
                                case PLACE_ONE: 
                                case SWAP_WITH_CURSOR: {
                                    this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-1, -1, this.f_9743_.f_36095_.m_182425_(), this.f_9743_.f_36096_.m_142621_()));
                                    this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(this.f_9743_.f_36096_.f_38840_, this.f_9743_.f_36095_.m_182425_(), p_9856_.m_133962_(), this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_()).m_7993_()));
                                    break block9;
                                }
                                case DROP_ALL_SLOT: 
                                case DROP_ONE_SLOT: {
                                    this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(this.f_9743_.f_36096_.f_38840_, this.f_9743_.f_36095_.m_182425_(), p_9856_.m_133962_(), this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_()).m_7993_()));
                                    break block9;
                                }
                                case DROP_ALL_CURSOR: 
                                case DROP_ONE_CURSOR: 
                                case CLONE_STACK: {
                                    this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-1, -1, this.f_9743_.f_36095_.m_182425_(), this.f_9743_.f_36096_.m_142621_()));
                                    break block9;
                                }
                            }
                        }
                    }
                    if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                        this.f_9743_.f_36096_.m_150429_();
                    }
                }
                for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(p_9856_.m_179582_())) {
                    this.f_9743_.f_36096_.m_182414_(entry.getIntKey(), (ItemStack)((Object)entry.getValue()));
                }
                this.f_9743_.f_36096_.m_150422_(p_9856_.m_179581_());
                this.f_9743_.f_36096_.m_150444_();
                if (flag) {
                    this.f_9743_.f_36096_.m_182423_();
                } else {
                    this.f_9743_.f_36096_.m_38946_();
                }
            }
        }
    }

    public void m_7191_(ServerboundPlaceRecipePacket p_9882_) {
        PacketUtils.m_131359_(p_9882_, this, this.f_9743_.m_183503_());
        this.f_9743_.m_9243_();
        if (!this.f_9743_.m_5833_() && this.f_9743_.f_36096_.f_38840_ == p_9882_.m_134249_() && this.f_9743_.f_36096_ instanceof RecipeBookMenu) {
            this.f_9745_.m_129894_().m_44043_(p_9882_.m_134252_()).ifPresent(p_184200_ -> ((RecipeBookMenu)this.f_9743_.f_36096_).m_6951_(p_9882_.m_134253_(), (Recipe<?>)p_184200_, this.f_9743_));
        }
    }

    public void m_6557_(ServerboundContainerButtonClickPacket p_9854_) {
        boolean flag;
        PacketUtils.m_131359_(p_9854_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        if (this.f_9743_.f_36096_.f_38840_ == p_9854_.m_133935_() && !this.f_9743_.m_5833_() && (flag = this.f_9743_.f_36096_.m_6366_(this.f_9743_, p_9854_.m_133938_()))) {
            this.f_9743_.f_36096_.m_38946_();
        }
    }

    public void m_5964_(ServerboundSetCreativeModeSlotPacket p_9915_) {
        PacketUtils.m_131359_(p_9915_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.f_8941_.m_9295_()) {
            boolean flag2;
            BlockPos blockpos;
            BlockEntity blockentity;
            boolean flag = p_9915_.m_134561_() < 0;
            ItemStack itemstack = p_9915_.m_134564_();
            CompoundTag compoundtag = BlockItem.m_186336_(itemstack);
            if (!itemstack.m_41619_() && compoundtag != null && compoundtag.m_128441_("x") && compoundtag.m_128441_("y") && compoundtag.m_128441_("z") && this.f_9743_.getBukkitEntity().hasPermission("minecraft.nbt.copy") && (blockentity = this.f_9743_.f_19853_.m_7702_(blockpos = BlockEntity.m_187472_(compoundtag))) != null) {
                blockentity.m_187476_(itemstack);
            }
            boolean flag1 = p_9915_.m_134561_() >= 1 && p_9915_.m_134561_() <= 45;
            boolean bl = flag2 = itemstack.m_41619_() || itemstack.m_41773_() >= 0 && itemstack.m_41613_() <= 64 && !itemstack.m_41619_();
            if (flag || flag1 && !ItemStack.m_41728_(this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_7993_(), p_9915_.m_134564_())) {
                CraftInventoryView inventory = this.f_9743_.f_36095_.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy((ItemStack)p_9915_.m_134564_());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (p_9915_.m_134561_() < 36) {
                    type = p_9915_.m_134561_() >= 5 && p_9915_.m_134561_() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : p_9915_.m_134561_(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (p_9915_.m_134561_() >= 0) {
                            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(this.f_9743_.f_36095_.f_38840_, this.f_9743_.f_36095_.m_182425_(), p_9915_.m_134561_(), this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_7993_()));
                            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-1, this.f_9743_.f_36095_.m_182425_(), -1, ItemStack.f_41583_));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_5852_(itemstack);
                this.f_9743_.f_36095_.m_38946_();
            } else if (flag && flag2 && this.f_9751_ < 200) {
                this.f_9751_ += 20;
                this.f_9743_.m_36176_(itemstack, true);
            }
        }
    }

    public void m_5527_(ServerboundSignUpdatePacket p_9921_) {
        List<String> list = Stream.of(p_9921_.m_134663_()).map(ChatFormatting::m_126649_).collect(Collectors.toList());
        this.m_9815_(list, p_184205_ -> this.m_9922_(p_9921_, (List<TextFilter.FilteredText>)p_184205_));
    }

    private void m_9922_(ServerboundSignUpdatePacket p_9923_, List<TextFilter.FilteredText> p_9924_) {
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        ServerLevel serverlevel = this.f_9743_.m_183503_();
        BlockPos blockpos = p_9923_.m_134660_();
        if (serverlevel.m_46805_(blockpos)) {
            BlockState blockstate = serverlevel.m_8055_(blockpos);
            BlockEntity blockentity = serverlevel.m_7702_(blockpos);
            if (!(blockentity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity signblockentity = (SignBlockEntity)blockentity;
            if (!signblockentity.m_59751_() || !this.f_9743_.m_142081_().equals(signblockentity.m_155726_())) {
                f_9744_.warn("Player {} just tried to change non-editable sign", (Object)this.f_9743_.m_7755_().getString());
                this.m_141995_(blockentity.m_183216_());
                return;
            }
            CraftPlayer player = this.f_9743_.getBukkitEntity();
            int x = p_9923_.m_134660_().m_123341_();
            int y = p_9923_.m_134660_().m_123342_();
            int z = p_9923_.m_134660_().m_123343_();
            String[] lines = new String[4];
            for (int i = 0; i < p_9924_.size(); ++i) {
                TextFilter.FilteredText textfilter$filteredtext = p_9924_.get(i);
                lines[i] = this.f_9743_.m_143387_() ? ChatFormatting.m_126649_((String)new TextComponent(ChatFormatting.m_126649_((String)textfilter$filteredtext.m_143722_())).getString()) : ChatFormatting.m_126649_((String)new TextComponent(ChatFormatting.m_126649_((String)textfilter$filteredtext.m_143719_())).getString());
            }
            SignChangeEvent event = new SignChangeEvent((Block)((CraftBlock)player.getWorld().getBlockAt(x, y, z)), (org.bukkit.entity.Player)this.f_9743_.getBukkitEntity(), lines);
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                Component[] components = CraftSign.sanitizeLines((String[])event.getLines());
                for (int i = 0; i < components.length; ++i) {
                    signblockentity.m_59732_(i, components[i]);
                }
                signblockentity.f_59721_ = false;
            }
            signblockentity.m_6596_();
            serverlevel.m_7260_(blockpos, blockstate, blockstate, 3);
        }
    }

    public void m_5683_(ServerboundKeepAlivePacket p_9870_) {
        PacketUtils.m_131359_(p_9870_, this, this.f_9743_.m_183503_());
        if (this.f_9748_ && p_9870_.m_134102_() == this.f_9749_) {
            int i = (int)(Util.m_137550_() - this.f_9747_);
            this.f_9743_.f_8943_ = (this.f_9743_.f_8943_ * 3 + i) / 4;
            this.f_9748_ = false;
        } else if (!this.m_9956_()) {
            this.m_9942_((Component)((Object)new TranslatableComponent("disconnect.timeout")));
        }
    }

    public void m_6828_(ServerboundPlayerAbilitiesPacket p_9887_) {
        PacketUtils.m_131359_(p_9887_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_150110_().f_35936_ && this.f_9743_.m_150110_().f_35935_ != p_9887_.m_134264_()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((org.bukkit.entity.Player)this.f_9743_.getBukkitEntity(), p_9887_.m_134264_());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f_9743_.m_150110_().f_35935_ = p_9887_.m_134264_();
            } else {
                this.f_9743_.m_6885_();
            }
        }
    }

    public void m_5617_(ServerboundClientInformationPacket p_9845_) {
        PacketUtils.m_131359_(p_9845_, this, this.f_9743_.m_183503_());
        this.f_9743_.m_9156_(p_9845_);
    }

    public void m_7423_(ServerboundCustomPayloadPacket p_9860_) {
        PacketUtils.m_131359_(p_9860_, this, this.f_9743_.m_183503_());
        NetworkHooks.onCustomPayload((ICustomPacket)p_9860_, (Connection)this.f_9742_);
        if (p_9860_.f_133980_.equals(CUSTOM_REGISTER)) {
            try {
                String channels = p_9860_.f_133981_.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                f_9744_.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!");
            }
        } else if (p_9860_.f_133980_.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = p_9860_.f_133981_.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                f_9744_.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!");
            }
        } else {
            try {
                byte[] data = new byte[p_9860_.f_133981_.readableBytes()];
                p_9860_.f_133981_.readBytes(data);
                this.cserver.getMessenger().dispatchIncomingMessage((org.bukkit.entity.Player)this.f_9743_.getBukkitEntity(), p_9860_.f_133980_.toString(), data);
            }
            catch (Exception ex) {
                f_9744_.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!");
            }
        }
    }

    public void m_7477_(ServerboundChangeDifficultyPacket p_9839_) {
        PacketUtils.m_131359_(p_9839_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_20310_(2) || this.m_9956_()) {
            this.f_9745_.m_129827_(p_9839_.m_133824_(), false);
        }
    }

    public void m_7728_(ServerboundLockDifficultyPacket p_9872_) {
        PacketUtils.m_131359_(p_9872_, this, this.f_9743_.m_183503_());
        if (this.f_9743_.m_20310_(2) || this.m_9956_()) {
            this.f_9745_.m_129958_(p_9872_.m_134115_());
        }
    }

    public ServerPlayer m_142253_() {
        return this.f_9743_;
    }

    public void chat(String s, boolean async) {
        block14: {
            block13: {
                if (s.isEmpty() || this.f_9743_.m_9241_() == ChatVisiblity.HIDDEN) {
                    return;
                }
                if (async || !s.startsWith("/")) break block13;
                this.m_9957_(s);
                break block14;
            }
            if (this.f_9743_.m_9241_() == ChatVisiblity.SYSTEM) break block14;
            CraftPlayer player = this.getCraftPlayer();
            final AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (org.bukkit.entity.Player)player, s, (Set)new LazyPlayerSet(this.f_9745_));
            Waitable wait = new Waitable(){

                protected Object evaluate() {
                    ServerGamePacketListenerImpl.this.cserver.getPluginManager().callEvent((Event)event);
                    return null;
                }
            };
            wait.run();
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((org.bukkit.entity.Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        ServerGamePacketListenerImpl.this.f_9745_.console.sendMessage(message);
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            for (ServerPlayer recipient : ServerGamePacketListenerImpl.this.f_9745_.m_6846_().m_11314_()) {
                                recipient.getBukkitEntity().sendMessage(ServerGamePacketListenerImpl.this.f_9743_.m_142081_(), message);
                            }
                        } else {
                            for (org.bukkit.entity.Player player : queueEvent.getRecipients()) {
                                player.sendMessage(ServerGamePacketListenerImpl.this.f_9743_.m_142081_(), message);
                            }
                        }
                        return null;
                    }
                };
                if (async) {
                    this.f_9745_.processQueue.add((Runnable)waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Exception processing chat event", e.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                this.f_9745_.console.sendMessage(s);
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    for (ServerPlayer recipient : this.f_9745_.m_6846_().m_11314_()) {
                        recipient.getBukkitEntity().sendMessage(this.f_9743_.m_142081_(), s);
                    }
                } else {
                    for (org.bukkit.entity.Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.f_9743_.m_142081_(), s);
                    }
                }
            }
        }
    }

    public void teleport(Location dest) {
        this.f_9743_.m_143425_(((CraftWorld)dest.getWorld()).getHandle());
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet(), true);
    }

    public final boolean isDisconnected() {
        return !this.f_9743_.joining && !this.f_9742_.m_129536_();
    }

    private /* synthetic */ Component lambda$handleChat$9(ServerChatEvent event, ServerPlayer p_184197_) {
        return this.f_9743_.m_143421_(p_184197_) ? event.getFilteredComponent() : event.getComponent();
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult m_143694_(ServerPlayer var1, net.minecraft.world.entity.Entity var2, InteractionHand var3);
    }
}

